import winston from 'winston';
import elastic from 'winston-elasticsearch';

winston.transports.ElasticSearch = elastic;

export default function(config) {
	const transportConfigs = config.get('transportConfigs');

	const options = {
		level: config.get('level'),
		exitOnError: false,
		transports: [],
		format: winston.format.combine(
			winston.format.timestamp(),
			winston.format.errors({ stack: true }),
			winston.format.json(),
		),
	};

	config.get('useTransports').forEach(transportName => {
		const transportConstructor = winston.transports[transportName];
		const transportConfig = transportConfigs.has(transportName)
			? Object.assign({}, transportConfigs.get(transportName))
			: {};

		if (transportName === 'Console') {
			transportConfig.format = winston.format.combine(
				winston.format.colorize(),
				winston.format.printf(
					info => `${info.timestamp} ${info.level}\t${info.message}${info.stack ? '\n' + info.stack : ''}`
				),
			);
		}

		const transport = new transportConstructor(transportConfig);
		options.transports.push(transport);
	});

	winston.configure(options);
}
