import winston from 'winston';
import fs from 'fs';
import Sftp from 'ssh2-sftp-client';

export default class SftpAgent {
	constructor(config) {
		this.config = config;
		const identityFile = config.get('identityFile');
		try {
			this.privateKey = fs.readFileSync(identityFile);
		} catch(e) {
			throw Error(`Can't read identity file ${identityFile}: ${e.message}`);
		}

		this.client = new Sftp('sftp-client');
	}

	async connect() {
		await this.client.connect({
			host: this.config.get('host'),
			username: this.config.get('username'),
			privateKey: this.privateKey,
		});
		this.remotePath = this.config.get('remoteDir') + '/';
	}

	async list(path, pattern) {
		return this.client.list(this.remotePath + path, pattern);
	}

	async downloadDir(src, dst) {
		return this.client.downloadDir(this.remotePath + src, dst);
	}

	async fastGet(src, dst) {
		return this.client.fastGet(this.remotePath + src, dst);
	}

	async close() {
		return this.client.end();
	}
}
