import fs from 'fs';
import path from 'path';
import winston from 'winston';
import rimraf from 'rimraf';
import winstonConfigurer from './winstonConfigurer';
import SftpAgent from './sftpAgent';
import FetchCvgJob from './fetchCvg';

import notarealresult from './pseudoResult';
import ImportNetwork from './importNtw';



process.chdir(__dirname + '/..'); // always run from application directory
const config = require('config'); // use old-fashioned require here, Babel would place import before chdir

winstonConfigurer(config.get('winston'));

// run everything in async function below
run().then(() => {
	winston.info('Finished.');
}).catch(e => {
	winston.error({
		message: e,
		error: e,
	});
});

async function run() {
	const workspaceDir = config.get('workspace');
	winston.info(`Running in ` + process.cwd() + `, using workspace ${workspaceDir}`);

	/*winston.info(`Removing all files from ${workspaceDir}`);
	rimraf.sync(path.join(workspaceDir, '*'));

	const sftpAgent = new SftpAgent(config.get('sftp'));
	await sftpAgent.connect();

	try {
		const job = new FetchCvgJob(config.get('cvg'), workspaceDir, sftpAgent);
		await job.run();
	} finally {
		sftpAgent.close();
	}*/

	let importNetworkJob = new ImportNetwork(config.get("postgres"), workspaceDir);
	importNetworkJob.run(notarealresult);

}
