import path from 'path';
import fs from 'fs';
import winston from 'winston';
import { spawn } from 'child_process';
import gdal from 'gdal';


const Mapping = [
	{ from: /.*existingDcs\/.*CZ_GSM_EXISTING_outdoor.*/, to: "coverage_dcs" },
	{ from: /.*CZ_GSM_EXISTING_outdoor.*/, to: "coverage_gsm" },
	{ from: /.*CZ_EVDO_EXISTING_outdoor.*/ , to: "coverage_cdma" },
	{ from: /.*CZ_UMTS_EXISTING_outdoor.*_C1*/, to: "coverage_umts_c1" },
	{ from: /.*CZ_UMTS_EXISTING_indoor.*_C1*/, to: "coverage_umts_c1_indoor" },
	{ from: /.*CZ_UMTS_EXISTING_outdoor.*_C2*/, to: "coverage_umts_c2" },
	{ from: /.*CZ_UMTS_EXISTING_indoor.*_C2*/, to: "coverage_umts_c2_indoor" },
	{ from: /.*CZ_UMTS_EXISTING_outdoor.*_C3*/, to: "coverage_umts_c3" },
	{ from: /.*CZ_UMTS_EXISTING_indoor.*_C3*/, to: "coverage_umts_c3_indoor" },
	{ from: /.*CZ_UMTS_EXISTING_outdoor.*_C4*/, to: "coverage_umts_c4" },
	{ from: /.*CZ_UMTS_EXISTING_indoor.*_C4*/, to: "coverage_umts_c4_indoor" },
	{ from: /.*SK_GSM_EXISTING_outdoor.*/, to: "coverage_sk_gsm" },
	{ from: /.*SK_UMTS_EXISTING_outdoor_.*/, to: "coverage_sk_umts" },
	{ from: /.*SK_UMTS900_EXISTING_outdoor.*/, to: "coverage_sk_umts_900" },
	{ from: /.*SK_UMTS2100_EXISTING_outdoor.*/, to: "coverage_sk_umts_2100" },
	{ from: /.*SK_TMSK_outdoor.*/, to: "coverage_sk_gsm_tmsk" }
];

export default class ImportNetwork {
	constructor(config, workspaceDir) {
		this.config = config;
		this.workspaceDir = workspaceDir;
	}

	async run(result) {
		winston.info('ImportNetwork running');

		let lev1task = result.result.tasks.poly.tasks;
		for (let keyl1 of Object.keys(lev1task)) {
			let taskl1 = lev1task[keyl1];

			for(let keyl2 of Object.keys(taskl1.tasks)) {
				await this.processTaskResult(keyl1, keyl2, taskl1.tasks[keyl2]);
			};			
		};

		//spawn("../ntw_postImport.sh");

		winston.info('ImportNetwork finished');
	}

	async processTaskResult(lev1, lev2, task) {
		let pth = path.join(this.workspaceDir, lev1, lev2); // TODO: use task.localPath (which begins with "workspace/") 

		try {
			let out = fs.readdirSync(pth);
			for (let dir of out) {
				if (!fs.lstatSync(path.join(pth, dir)).isDirectory()) {
					winston.silly(`Ignoring file '${lev1}/${lev2}/${dir}': not a directory`);
				} else {
					await this.processDirectory(lev1, lev2, dir);
				} 
			}
		} catch (err) {
			winston.error(`Directory ${lev1}/${lev2} was not found`, err);
			return;
		}
		
	}

	async processDirectory(lev1, lev2, lev3) {
		let pth = path.join(this.workspaceDir, lev1, lev2, lev3);

		let out = fs.readdirSync(pth);
		let shpfile = out.find(fl => path.extname(fl) == ".shp");

		if (!shpfile) {
			winston.info(`Directory ${lev1}/${lev2}/${lev3} does not contain .shp file`);
			return;
		}

		let map = this.findMapping(shpfile);

		/*
		if (!map) {
			winston.info(`${lev3} is not going to be processed`);
			return;
		}*/

		let file = path.join(pth, shpfile);

		this.logFileCellnames(lev1, lev2, lev3, file);

	}

	async logFileCellnames(lev1, lev2, lev3, file) {
		var dataset = gdal.open(file);
		
		let layer = dataset.layers.get(0);
	
		let lfc = layer.features.count();
	
		let cellnames = [];

		for (let i = 0; i < layer.features.count(); i++) {
			let ftr = layer.features.get(i);
			cellnames.push(ftr.fields.get(0));
		}

		winston.info(`Got shapefile ${file} containing ${lfc} features`, {
			processedFile: file,
			processed_lev1: lev1,
			processed_lev2: lev2,
			processed_lev3: lev3,
			feature_count: lfc,
			cellnames: cellnames});
	
	}

	/* BULLSHIT 
	async processDirectory(lev1, lev2, lev3) {
		let pth = path.join(this.workspaceDir, lev1, lev2, lev3);

		let out = fs.readdirSync(pth);
		let shpfile = out.find(fl => path.extname(fl) == ".shp");

		if (!shpfile) {
			winston.info(`Directory ${lev1}/${lev2}/${lev3} does not contain .shp file`);
			return;
		}

		let map = this.findMapping(shpfile);

		if (!map) {
			winston.silly(`${lev3} will not be mapped to anything`);
			return;
		}

		let file = path.join(pth, shpfile);

		winston.info("Spawning shp2pgsql process");
		let shp2psql = spawn("shp2pgsql", [ "-c", "-g", "way", "-s", "4326:900913", file, this.config.temptable], { stdio: [ "pipe", "pipe", "inherit" ] });
		let psql = spawn("/usr/bin/psql", 
				[ "-q", "-h", this.config.host, "-d", this.config.database, "-U", this.config.user], 
				{ env: { "PGPASSWORD": this.config.password},  stdio: [ "pipe", "inherit", "inherit" ] } );

		psql.stdin.write("\\set ON_ERROR_STOP 1\n", (err) => { if (err) { winston.error("Tried to write ON_ERROR_STOP=1 to psql input, but it failed", err);} });
		shp2psql.stdout.pipe(psql.stdin);
		psql.stdin.on("error", (err) => { // ???
			if (err.code == "EPIPE") psql.kill("SIGPIPE");
		});

		await this.awaitProcess(psql);

		let domin = spawn("/usr/bin/psql", 
			["-q", "-h", this.config.host, "-d", this.config.database, "-U", this.config.user, "-v", `target=${map.to}`, "-f", this.config.dominance_script], 
			{ env: { "PGPASSWORD": this.config.password}, stdio: "inherit" });
		await this.awaitProcess(domin);
	}

	awaitProcess(proc) {
		return new Promise( (res, rej) => {
			proc.on("exit", (code, signal) => { 
				winston.info(`Process 'psql' ended with code ${code} and signal ${signal}`);
				res(); 
			});
		});
	}*/
	
/*
	findMapping(path) {
		return Mapping.find( (itm) => {
			return itm.from.test(path);
		});
	}*/
}
